<?php
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/helpers.php';
$page_title = 'Reports';
$db = db();

$from = $_GET['from'] ?? date('Y-m-01');
$to   = $_GET['to'] ?? date('Y-m-d');

$sales = one($db, "SELECT COALESCE(SUM(total),0) AS v FROM invoices WHERE invoice_date BETWEEN ? AND ?", "ss", [$from, $to])['v'] ?? 0;
$payments = one($db, "SELECT COALESCE(SUM(amount),0) AS v FROM payments WHERE payment_date BETWEEN ? AND ?", "ss", [$from, $to])['v'] ?? 0;

$debtors = all($db, "
  SELECT c.id, c.name, (COALESCE(SUM(i.balance),0)+c.opening_balance) AS bal
  FROM customers c
  LEFT JOIN invoices i ON i.customer_id=c.id
  GROUP BY c.id
  HAVING bal > 0.0001
  ORDER BY bal DESC
  LIMIT 50
");

include __DIR__ . '/../includes/header.php';
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h4 class="mb-0">Reports</h4>
</div>

<div class="card p-3 mb-3">
  <form class="row g-2 align-items-end">
    <div class="col-6 col-md-3">
      <label class="form-label">From</label>
      <input class="form-control" type="date" name="from" value="<?= h($from) ?>">
    </div>
    <div class="col-6 col-md-3">
      <label class="form-label">To</label>
      <input class="form-control" type="date" name="to" value="<?= h($to) ?>">
    </div>
    <div class="col-12 col-md-6 d-flex gap-2">
      <button class="btn btn-outline-light w-100">Run</button>
      <a class="btn btn-outline-secondary w-100" href="<?= base_url() ?>/public/reports.php">Reset</a>
    </div>
  </form>
</div>

<div class="row g-3">
  <div class="col-12 col-md-6">
    <div class="card p-3">
      <div class="small opacity-75">Sales (<?= h($from) ?> → <?= h($to) ?>)</div>
      <div class="fs-3 fw-bold">KES <?= money($sales) ?></div>
    </div>
  </div>
  <div class="col-12 col-md-6">
    <div class="card p-3">
      <div class="small opacity-75">Payments received (<?= h($from) ?> → <?= h($to) ?>)</div>
      <div class="fs-3 fw-bold text-success">KES <?= money($payments) ?></div>
    </div>
  </div>

  <div class="col-12">
    <div class="card p-3">
      <h5 class="mb-2">Outstanding balances (Top 50)</h5>
      <div class="table-responsive">
        <table class="table table-sm align-middle">
          <thead><tr><th>Customer</th><th class="text-end">Balance</th><th></th></tr></thead>
          <tbody>
            <?php if(!$debtors): ?><tr><td colspan="3" class="opacity-75">No outstanding balances.</td></tr><?php endif; ?>
            <?php foreach($debtors as $d): ?>
              <tr>
                <td><?= h($d['name']) ?></td>
                <td class="text-end text-warning">KES <?= money($d['bal']) ?></td>
                <td class="text-end"><a class="btn btn-sm btn-outline-info" href="<?= base_url() ?>/public/customer_statement.php?id=<?= (int)$d['id'] ?>">Statement</a></td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../includes/footer.php'; ?>
