<?php
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/helpers.php';
$page_title = 'Customers';
$db = db();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check();
  $name = trim($_POST['name'] ?? '');
  $phone = trim($_POST['phone'] ?? '');
  $limit = (float)($_POST['credit_limit'] ?? 0);
  $opening = (float)($_POST['opening_balance'] ?? 0);
  if ($name !== '') {
    $st = $db->prepare("INSERT INTO customers(name,phone,credit_limit,opening_balance) VALUES(?,?,?,?)");
    $st->bind_param("ssdd", $name, $phone, $limit, $opening);
    $st->execute(); $st->close();
    flash_set('success', 'Customer added.');
    header('Location: ' . base_url() . '/public/customers.php');
    exit;
  }
}

$rows = all($db, "
  SELECT c.*,
    (COALESCE(SUM(i.balance),0) + c.opening_balance) AS balance
  FROM customers c
  LEFT JOIN invoices i ON i.customer_id=c.id
  GROUP BY c.id
  ORDER BY c.id DESC
  LIMIT 500
");

include __DIR__ . '/../includes/header.php';
?>
<div class="row g-3">
  <div class="col-12 col-lg-4">
    <div class="card p-3">
      <h5>Add customer</h5>
      <form method="post" class="mt-2">
        <?= csrf_field() ?>
        <div class="mb-2">
          <label class="form-label">Name</label>
          <input class="form-control" name="name" required placeholder="e.g. Jubilee Merchants">
        </div>
        <div class="mb-2">
          <label class="form-label">Phone</label>
          <input class="form-control" name="phone" placeholder="e.g. 07xx xxx xxx">
        </div>
        <div class="mb-2">
          <label class="form-label">Credit limit (optional)</label>
          <input class="form-control" name="credit_limit" type="number" step="0.01" value="0">
        </div>
        <div class="mb-2">
          <label class="form-label">Opening balance (optional)</label>
          <input class="form-control" name="opening_balance" type="number" step="0.01" value="0">
        </div>
        <button class="btn btn-primary">Save</button>
      </form>
    </div>
  </div>

  <div class="col-12 col-lg-8">
    <div class="card p-3">
      <h5 class="mb-2">Customers</h5>
      <div class="table-responsive">
        <table class="table table-sm align-middle">
          <thead><tr><th>Name</th><th>Phone</th><th class="text-end">Balance</th><th></th></tr></thead>
          <tbody>
          <?php foreach($rows as $c): ?>
            <tr>
              <td><?= h($c['name']) ?></td>
              <td><?= h($c['phone']) ?></td>
              <td class="text-end <?= ((float)$c['balance']>0.0001)?'text-warning':'' ?>">KES <?= money($c['balance']) ?></td>
              <td class="text-end">
                <a class="btn btn-sm btn-outline-info" href="<?= base_url() ?>/public/customer_statement.php?id=<?= (int)$c['id'] ?>">Statement</a>
              </td>
            </tr>
          <?php endforeach; ?>
          </tbody>
        </table>
      </div>
      <div class="small opacity-75">Showing up to 500 latest customers.</div>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../includes/footer.php'; ?>
