<?php
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/helpers.php';
$db = db();

$id = (int)($_GET['id'] ?? 0);
$c = $id ? one($db, "SELECT * FROM customers WHERE id=?", "i", [$id]) : null;
if(!$c){ http_response_code(404); die('Customer not found'); }
$page_title = 'Statement — ' . $c['name'];

$invs = all($db, "SELECT * FROM invoices WHERE customer_id=? ORDER BY invoice_date DESC, id DESC", "i", [$id]);

$payments = all($db, "SELECT * FROM payments WHERE customer_id=? ORDER BY payment_date DESC, id DESC", "i", [$id]);

$inv_total = one($db, "SELECT COALESCE(SUM(total),0) AS v FROM invoices WHERE customer_id=?","i",[$id])['v'] ?? 0;
$inv_bal   = one($db, "SELECT COALESCE(SUM(balance),0) AS v FROM invoices WHERE customer_id=?","i",[$id])['v'] ?? 0;
$pay_total = one($db, "SELECT COALESCE(SUM(amount),0) AS v FROM payments WHERE customer_id=?","i",[$id])['v'] ?? 0;

$balance = ((float)$c['opening_balance']) + (float)$inv_bal; // simplistic balance view

include __DIR__ . '/../includes/header.php';
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <div>
    <h4 class="mb-0"><?= h($c['name']) ?></h4>
    <div class="small opacity-75"><?= h($c['phone']) ?></div>
  </div>
  <div class="d-flex gap-2">
    <a class="btn btn-outline-light" href="<?= base_url() ?>/public/customers.php">Back</a>
    <a class="btn btn-primary" href="<?= base_url() ?>/public/invoice_new.php">New invoice</a>
  </div>
</div>

<div class="row g-3">
  <div class="col-12 col-lg-4">
    <div class="card p-3">
      <div class="small opacity-75">Total invoiced</div>
      <div class="fs-4 fw-bold">KES <?= money($inv_total) ?></div>
      <hr class="border-secondary">
      <div class="small opacity-75">Total payments</div>
      <div class="fs-4 fw-bold text-success">KES <?= money($pay_total) ?></div>
      <hr class="border-secondary">
      <div class="small opacity-75">Outstanding (open balances)</div>
      <div class="fs-4 fw-bold text-warning">KES <?= money($inv_bal) ?></div>
      <div class="small opacity-75 mt-2">Opening balance: KES <?= money($c['opening_balance']) ?></div>
    </div>
  </div>

  <div class="col-12 col-lg-8">
    <div class="card p-3 mb-3">
      <h5 class="mb-2">Invoices</h5>
      <div class="table-responsive">
        <table class="table table-sm align-middle">
          <thead><tr><th>Date</th><th>Invoice</th><th class="text-end">Total</th><th class="text-end">Balance</th><th>Status</th><th></th></tr></thead>
          <tbody>
            <?php if(!$invs): ?><tr><td colspan="6" class="opacity-75">No invoices yet.</td></tr><?php endif; ?>
            <?php foreach($invs as $i): ?>
              <tr>
                <td><?= h($i['invoice_date']) ?></td>
                <td class="fw-semibold"><?= h($i['invoice_no']) ?></td>
                <td class="text-end">KES <?= money($i['total']) ?></td>
                <td class="text-end <?= ((float)$i['balance']>0.0001)?'text-warning':'' ?>">KES <?= money($i['balance']) ?></td>
                <td><?= h($i['status']) ?></td>
                <td class="text-end"><a class="btn btn-sm btn-outline-info" href="<?= base_url() ?>/public/invoice_view.php?id=<?= (int)$i['id'] ?>">View</a></td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>

    <div class="card p-3">
      <h5 class="mb-2">Payments</h5>
      <div class="table-responsive">
        <table class="table table-sm align-middle">
          <thead><tr><th>Date</th><th>Method</th><th>Reference</th><th class="text-end">Amount</th></tr></thead>
          <tbody>
            <?php if(!$payments): ?><tr><td colspan="4" class="opacity-75">No payments yet.</td></tr><?php endif; ?>
            <?php foreach($payments as $p): ?>
              <tr>
                <td><?= h($p['payment_date']) ?></td>
                <td><?= h($p['method']) ?></td>
                <td><?= h($p['reference']) ?></td>
                <td class="text-end">KES <?= money($p['amount']) ?></td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
      <a class="btn btn-outline-info mt-2" href="<?= base_url() ?>/public/payments.php?customer_id=<?= (int)$c['id'] ?>">Record payment</a>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../includes/footer.php'; ?>
