<?php
// includes/helpers.php
function h($v): string { return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8'); }
function money($n): string { return number_format((float)$n, 2); }

function app_cfg(): array {
  static $cfg = null;
  if ($cfg) return $cfg;
  $cfg = require __DIR__ . '/../config/app.php';
  return $cfg;
}
function base_url(): string {
  $cfg = app_cfg();
  $b = rtrim((string)($cfg['base_url'] ?? ''), '/');
  return $b;
}

/** Flash messages */
function flash_set(string $type, string $msg): void {
  $_SESSION['_flash'] = ['type' => $type, 'msg' => $msg];
}
function flash_get(): ?array {
  $f = $_SESSION['_flash'] ?? null;
  unset($_SESSION['_flash']);
  return $f;
}

/** CSRF */
function csrf_token(): string {
  if (!isset($_SESSION['_csrf'])) $_SESSION['_csrf'] = bin2hex(random_bytes(16));
  return $_SESSION['_csrf'];
}
function csrf_field(): string {
  return '<input type="hidden" name="_csrf" value="'.h(csrf_token()).'">';
}
function csrf_check(): void {
  $t = $_POST['_csrf'] ?? '';
  if (!$t || !hash_equals((string)($_SESSION['_csrf'] ?? ''), (string)$t)) {
    http_response_code(403);
    die('CSRF validation failed.');
  }
}

/** Small DB helpers */
function one(mysqli $db, string $sql, string $types='', array $params=[]){
  $st = $db->prepare($sql);
  if ($types !== '') $st->bind_param($types, ...$params);
  $st->execute();
  $r = $st->get_result()->fetch_assoc();
  $st->close();
  return $r;
}
function all(mysqli $db, string $sql, string $types='', array $params=[]): array {
  $st = $db->prepare($sql);
  if ($types !== '') $st->bind_param($types, ...$params);
  $st->execute();
  $rows = $st->get_result()->fetch_all(MYSQLI_ASSOC);
  $st->close();
  return $rows ?: [];
}
