<?php
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/helpers.php';
$page_title = 'Shifts';
$db = db();

$uid = (int)($_SESSION['user_id'] ?? 0);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check();
  if (isset($_POST['open_shift'])) {
    $opening_cash = (float)($_POST['opening_cash'] ?? 0);
    $notes = trim($_POST['notes'] ?? '');
    $st = $db->prepare("INSERT INTO shifts(opened_at,opened_by,opening_cash,notes) VALUES(NOW(),?,?,?)");
    $st->bind_param("ids", $uid, $opening_cash, $notes);
    $st->execute();
    $shift_id = $st->insert_id;
    $st->close();
    $_SESSION['shift_id'] = $shift_id;
    flash_set('success','Shift opened (#'.$shift_id.').');
    header('Location: ' . base_url() . '/public/shifts.php');
    exit;
  }
  if (isset($_POST['close_shift'])) {
    $shift_id = (int)($_SESSION['shift_id'] ?? 0);
    $closing_cash = (float)($_POST['closing_cash'] ?? 0);
    $notes = trim($_POST['notes2'] ?? '');
    if ($shift_id>0) {
      $st = $db->prepare("UPDATE shifts SET closed_at=NOW(), closing_cash=?, notes=CONCAT(IFNULL(notes,''), ' | ', ?) WHERE id=? AND closed_at IS NULL");
      $st->bind_param("dsi", $closing_cash, $notes, $shift_id);
      $st->execute();
      $st->close();
      unset($_SESSION['shift_id']);
      flash_set('success','Shift closed.');
      header('Location: ' . base_url() . '/public/shifts.php');
      exit;
    }
  }
}

$current_shift_id = (int)($_SESSION['shift_id'] ?? 0);
$current_shift = $current_shift_id ? one($db, "SELECT * FROM shifts WHERE id=?","i",[$current_shift_id]) : null;

$recent = all($db, "
  SELECT s.*, u.name AS user_name
  FROM shifts s
  JOIN users u ON u.id=s.opened_by
  ORDER BY s.id DESC
  LIMIT 50
");

include __DIR__ . '/../includes/header.php';
?>
<div class="row g-3">
  <div class="col-12 col-lg-5">
    <div class="card p-3">
      <h5 class="mb-2">Current shift</h5>
      <?php if($current_shift): ?>
        <div class="small opacity-75">Open since</div>
        <div class="fw-semibold"><?= h($current_shift['opened_at']) ?></div>
        <div class="small opacity-75 mt-2">Opening cash</div>
        <div class="fw-semibold">KES <?= money($current_shift['opening_cash']) ?></div>

        <hr class="border-secondary my-3">

        <form method="post">
          <?= csrf_field() ?>
          <input type="hidden" name="close_shift" value="1">
          <div class="mb-2">
            <label class="form-label">Closing cash (counted)</label>
            <input class="form-control" name="closing_cash" type="number" step="0.01" value="0" required>
          </div>
          <div class="mb-2">
            <label class="form-label">Notes (optional)</label>
            <input class="form-control" name="notes2" placeholder="optional">
          </div>
          <button class="btn btn-danger w-100">Close shift</button>
        </form>
      <?php else: ?>
        <div class="opacity-75">No open shift.</div>
        <hr class="border-secondary my-3">
        <form method="post">
          <?= csrf_field() ?>
          <input type="hidden" name="open_shift" value="1">
          <div class="mb-2">
            <label class="form-label">Opening cash</label>
            <input class="form-control" name="opening_cash" type="number" step="0.01" value="0" required>
          </div>
          <div class="mb-2">
            <label class="form-label">Notes (optional)</label>
            <input class="form-control" name="notes" placeholder="optional">
          </div>
          <button class="btn btn-primary w-100">Open shift</button>
        </form>
      <?php endif; ?>
      <div class="small opacity-75 mt-3">Invoices can still be created without shifts (MVP).</div>
    </div>
  </div>

  <div class="col-12 col-lg-7">
    <div class="card p-3">
      <h5 class="mb-2">Recent shifts</h5>
      <div class="table-responsive">
        <table class="table table-sm align-middle">
          <thead><tr><th>#</th><th>Opened</th><th>Closed</th><th>User</th><th class="text-end">Open Cash</th><th class="text-end">Close Cash</th></tr></thead>
          <tbody>
            <?php foreach($recent as $s): ?>
              <tr>
                <td><?= (int)$s['id'] ?></td>
                <td><?= h($s['opened_at']) ?></td>
                <td><?= h($s['closed_at'] ?? '—') ?></td>
                <td><?= h($s['user_name']) ?></td>
                <td class="text-end">KES <?= money($s['opening_cash']) ?></td>
                <td class="text-end">KES <?= money($s['closing_cash']) ?></td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../includes/footer.php'; ?>
