<?php
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/helpers.php';
$db = db();

$id = (int)($_GET['id'] ?? 0);
$r = $id ? one($db, "
  SELECT r.*, c.name AS customer_name, i.invoice_no
  FROM returns r
  JOIN customers c ON c.id=r.customer_id
  LEFT JOIN invoices i ON i.id=r.invoice_id
  WHERE r.id=?
", "i", [$id]) : null;
if(!$r){ http_response_code(404); die('Return not found'); }

$page_title = 'Return ' . $r['return_no'];

$lines = all($db, "
  SELECT ri.*, it.name AS item_name, u.uom_name
  FROM return_items ri
  JOIN items it ON it.id=ri.item_id
  JOIN item_uoms u ON u.id=ri.uom_id
  WHERE ri.return_id=?
  ORDER BY ri.id ASC
", "i", [$id]);

include __DIR__ . '/../includes/header.php';
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <div>
    <h4 class="mb-0"><?= h($r['return_no']) ?></h4>
    <div class="small opacity-75"><?= h($r['return_date']) ?> • <?= h($r['customer_name']) ?> • Method: <?= h($r['method']) ?></div>
    <div class="small opacity-75">Invoice: <?= h($r['invoice_no'] ?? '—') ?></div>
  </div>
  <div class="d-flex gap-2">
    <a class="btn btn-outline-light" href="<?= base_url() ?>/public/returns.php">Back</a>
  </div>
</div>

<div class="card p-3">
  <h5 class="mb-2">Items</h5>
  <div class="table-responsive">
    <table class="table table-sm align-middle">
      <thead><tr><th>Item</th><th>UOM</th><th class="text-end">Qty</th><th class="text-end">Price</th><th class="text-end">Total</th></tr></thead>
      <tbody>
        <?php foreach($lines as $l): ?>
          <tr>
            <td><?= h($l['item_name']) ?></td>
            <td><?= h($l['uom_name']) ?></td>
            <td class="text-end"><?= h($l['qty']) ?></td>
            <td class="text-end">KES <?= money($l['price']) ?></td>
            <td class="text-end fw-semibold">KES <?= money($l['line_total']) ?></td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
  <div class="text-end mt-2">
    <div class="opacity-75 small">Return total</div>
    <div class="fs-4 fw-bold">KES <?= money($r['total']) ?></div>
  </div>
</div>
<?php include __DIR__ . '/../includes/footer.php'; ?>
