<?php
require_once __DIR__ . '/_pos_boot.php';
csrf_check();

$item_id = (int)($_POST['item_id'] ?? 0);
$uom_id  = (int)($_POST['uom_id'] ?? 0);
$qty     = (float)($_POST['qty'] ?? 1);

if($item_id<=0 || $uom_id<=0 || $qty<=0) json_out(['ok'=>false,'msg'=>'Invalid line']);

$item = one($db, "SELECT id,name FROM items WHERE id=?","i",[$item_id]);
$u = one($db, "SELECT id,uom_name,price FROM item_uoms WHERE id=? AND item_id=?","ii",[$uom_id,$item_id]);
if(!$item || !$u) json_out(['ok'=>false,'msg'=>'Item/UOM not found']);

$price = (float)$u['price'];
$cart = pos_cart();
$cart[] = [
  'item_id'=>$item_id,
  'uom_id'=>$uom_id,
  'name'=>$item['name'],
  'uom_name'=>$u['uom_name'],
  'qty'=>$qty,
  'price'=>$price,
  'line_total'=>$qty*$price,
];
pos_cart_set($cart);
json_out(['ok'=>true,'cart'=>$cart,'totals'=>pos_cart_totals($cart)]);
