<?php
require_once __DIR__ . '/../../includes/auth.php';
require_once __DIR__ . '/../../includes/helpers.php';
require_once __DIR__ . '/../../includes/mpesa.php';

$db = db();

function pos_cart(): array { return $_SESSION['pos_cart'] ?? []; }
function pos_cart_set(array $cart): void { $_SESSION['pos_cart'] = $cart; }
function pos_cart_clear(): void { unset($_SESSION['pos_cart']); }

function pos_cart_totals(array $cart): array {
  $subtotal = 0.0;
  foreach($cart as $l){ $subtotal += (float)($l['line_total'] ?? 0); }
  return ['subtotal'=>$subtotal, 'total'=>$subtotal];
}

function pos_walkin_customer_id(mysqli $db): int {
  $row = one($db, "SELECT id FROM customers WHERE name='Walk-in' LIMIT 1");
  if ($row && (int)$row['id']>0) return (int)$row['id'];
  $st = $db->prepare("INSERT INTO customers(name,phone,credit_limit,opening_balance) VALUES('Walk-in',NULL,0,0)");
  $st->execute(); $id = $st->insert_id; $st->close();
  return (int)$id;
}

function json_out($arr){
  header('Content-Type: application/json; charset=utf-8');
  echo json_encode($arr);
  exit;
}
