<?php
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/helpers.php';
$db = db();

$id = (int)($_GET['id'] ?? 0);
$inv = $id ? one($db, "
  SELECT i.*, c.name AS customer_name, c.phone
  FROM invoices i JOIN customers c ON c.id=i.customer_id
  WHERE i.id=?
", "i", [$id]) : null;
if(!$inv){ http_response_code(404); die('Invoice not found'); }

$page_title = 'Invoice ' . $inv['invoice_no'];

$lines = all($db, "
  SELECT li.*, it.name AS item_name, u.uom_name
  FROM invoice_items li
  JOIN items it ON it.id=li.item_id
  JOIN item_uoms u ON u.id=li.uom_id
  WHERE li.invoice_id=?
  ORDER BY li.id ASC
", "i", [$id]);

$payments = all($db, "
  SELECT p.id, p.payment_date, p.method, p.reference, pa.amount
  FROM payment_allocations pa
  JOIN payments p ON p.id=pa.payment_id
  WHERE pa.invoice_id=?
  ORDER BY p.id DESC
", "i", [$id]);

include __DIR__ . '/../includes/header.php';
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <div>
    <h4 class="mb-0"><?= h($inv['invoice_no']) ?></h4>
    <div class="small opacity-75"><?= h($inv['invoice_date']) ?> • <?= h($inv['customer_name']) ?> <?= $inv['phone'] ? '• '.h($inv['phone']) : '' ?></div>
  </div>
  <div class="d-flex gap-2">
    <a class="btn btn-outline-light" href="<?= base_url() ?>/public/invoices.php">Back</a>
    <a class="btn btn-primary" href="<?= base_url() ?>/public/payments.php?customer_id=<?= (int)$inv['customer_id'] ?>">Record payment</a>
  </div>
</div>

<div class="row g-3">
  <div class="col-12 col-lg-8">
    <div class="card p-3">
      <h5 class="mb-2">Items</h5>
      <div class="table-responsive">
        <table class="table table-sm align-middle">
          <thead><tr><th>Item</th><th>UOM</th><th class="text-end">Qty</th><th class="text-end">Price</th><th class="text-end">Total</th></tr></thead>
          <tbody>
            <?php foreach($lines as $l): ?>
              <tr>
                <td><?= h($l['item_name']) ?></td>
                <td><?= h($l['uom_name']) ?></td>
                <td class="text-end"><?= h($l['qty']) ?></td>
                <td class="text-end">KES <?= money($l['price']) ?></td>
                <td class="text-end fw-semibold">KES <?= money($l['line_total']) ?></td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>

      <div class="text-end mt-2">
        <div class="opacity-75 small">Total</div>
        <div class="fs-4 fw-bold">KES <?= money($inv['total']) ?></div>
        <div class="opacity-75 small mt-2">Balance</div>
        <div class="fs-4 fw-bold <?= ((float)$inv['balance']>0.0001)?'text-warning':'text-success' ?>">KES <?= money($inv['balance']) ?></div>
        <span class="badge text-bg-<?= ((float)$inv['balance']<=0.0001)?'success':(((float)$inv['balance']<(float)$inv['total'])?'warning':'secondary') ?>"><?= h($inv['status']) ?></span>
      </div>
    </div>
  </div>

  <div class="col-12 col-lg-4">
    <div class="card p-3">
      <h5 class="mb-2">Payments allocated</h5>
      <div class="table-responsive">
        <table class="table table-sm align-middle">
          <thead><tr><th>Date</th><th>Method</th><th class="text-end">Amount</th></tr></thead>
          <tbody>
            <?php if(!$payments): ?>
              <tr><td colspan="3" class="opacity-75">No payments allocated yet.</td></tr>
            <?php endif; ?>
            <?php foreach($payments as $p): ?>
              <tr>
                <td><?= h($p['payment_date']) ?></td>
                <td><?= h($p['method']) ?></td>
                <td class="text-end">KES <?= money($p['amount']) ?></td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
      <div class="small opacity-75">Allocate payments from the Payments page.</div>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../includes/footer.php'; ?>
