<?php
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/helpers.php';
$page_title = 'Dashboard';
$db = db();

$today = date('Y-m-d');
$kpi_sales_today = one($db, "SELECT COALESCE(SUM(total),0) AS v FROM invoices WHERE invoice_date = ?", "s", [$today])['v'] ?? 0;
$kpi_outstanding = one($db, "SELECT COALESCE(SUM(balance),0) AS v FROM invoices WHERE balance > 0.0001")['v'] ?? 0;
$kpi_pay_today = one($db, "SELECT COALESCE(SUM(amount),0) AS v FROM payments WHERE payment_date = ?", "s", [$today])['v'] ?? 0;
$top_debtors = all($db, "
  SELECT c.id, c.name, COALESCE(SUM(i.balance),0) AS bal
  FROM customers c
  LEFT JOIN invoices i ON i.customer_id=c.id AND i.balance>0.0001
  GROUP BY c.id
  HAVING bal>0.0001
  ORDER BY bal DESC
  LIMIT 8
");

include __DIR__ . '/../includes/header.php';
?>
<div class="row g-3">
  <div class="col-12 col-md-4">
    <div class="card p-3">
      <div class="small opacity-75">Sales today</div>
      <div class="fs-3 fw-bold">KES <?= money($kpi_sales_today) ?></div>
      <div class="small opacity-75"><?= h($today) ?></div>
      <div class="small opacity-75 mt-1">Shift: <?= isset($_SESSION['shift_id']) ? ('#'.(int)$_SESSION['shift_id'].' open') : 'none' ?></div>
    </div>
  </div>
  <div class="col-12 col-md-4">
    <div class="card p-3">
      <div class="small opacity-75">Outstanding credit</div>
      <div class="fs-3 fw-bold text-warning">KES <?= money($kpi_outstanding) ?></div>
      <div class="small opacity-75">Unpaid & partial invoices</div>
    </div>
  </div>
  <div class="col-12 col-md-4">
    <div class="card p-3">
      <div class="small opacity-75">Payments received today</div>
      <div class="fs-3 fw-bold text-success">KES <?= money($kpi_pay_today) ?></div>
      <div class="small opacity-75"><?= h($today) ?></div>
    </div>
  </div>

  <div class="col-12">
    <div class="card p-3">
      <div class="d-flex justify-content-between align-items-center mb-2">
        <h5 class="mb-0">Top debtors</h5>
        <a class="btn btn-outline-light btn-sm" href="<?= base_url() ?>/public/reports.php">Reports</a>
      </div>
      <div class="table-responsive">
        <table class="table table-sm align-middle">
          <thead><tr><th>Customer</th><th class="text-end">Balance</th><th></th></tr></thead>
          <tbody>
            <?php if(!$top_debtors): ?>
              <tr><td colspan="3" class="opacity-75">No outstanding balances.</td></tr>
            <?php endif; ?>
            <?php foreach($top_debtors as $r): ?>
              <tr>
                <td><?= h($r['name']) ?></td>
                <td class="text-end">KES <?= money($r['bal']) ?></td>
                <td class="text-end">
                  <a class="btn btn-sm btn-outline-info" href="<?= base_url() ?>/public/customer_statement.php?id=<?= (int)$r['id'] ?>">Statement</a>
                </td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../includes/footer.php'; ?>
